"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _helpers = require("../../../shared/helpers");
var _types = require("../../../definitions/types");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  getSuggestedUserDefinedColumnName,
  command,
  innerText
}) {
  // ROW col0 = /
  if (/=\s*$/.test(innerText)) {
    return (0, _factories.getFunctionSuggestions)({
      location: _types.Location.ROW
    });
  }

  // ROW col0 = 23 /
  else if (command.args.length > 0 && !(0, _helpers.isRestartingExpression)(innerText)) {
    return [{
      ..._complete_items.pipeCompleteItem,
      command: _factories.TRIGGER_SUGGESTION_COMMAND
    }, {
      ..._complete_items.commaCompleteItem,
      text: ', ',
      command: _factories.TRIGGER_SUGGESTION_COMMAND
    }];
  }

  // ROW /
  // ROW foo = "bar", /
  return [(0, _factories.getNewUserDefinedColumnSuggestion)(getSuggestedUserDefinedColumnName()), ...(0, _factories.getFunctionSuggestions)({
    location: _types.Location.ROW
  })];
}