"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _helper = require("../../helper");
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
var _metadata = require("../metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText,
  command,
  getSources,
  getRecommendedQueriesSuggestions,
  getSourcesFromQuery
}) {
  if ((0, _helpers.withinQuotes)(innerText)) {
    return [];
  }
  const suggestions = [];
  const indexes = getSourcesFromQuery('index');
  const metadataSuggestions = (0, _metadata.getMetadataSuggestions)(command, innerText);
  if (metadataSuggestions) {
    return metadataSuggestions;
  }
  const metadataOverlap = (0, _helper.getOverlapRange)(innerText, 'METADATA');

  // FROM /
  if (indexes.length === 0) {
    suggestions.push(...(0, _helper.getSourceSuggestions)(await getSources(), indexes.map(({
      name
    }) => name)));
  }
  // FROM something /
  else if (indexes.length > 0 && /\s$/.test(innerText) && !(0, _helpers.isRestartingExpression)(innerText)) {
    suggestions.push(_metadata.metadataSuggestion);
    suggestions.push(_complete_items.commaCompleteItem);
    suggestions.push(_complete_items.pipeCompleteItem);
    suggestions.push(...(await getRecommendedQueriesSuggestions(innerText)));
  }
  // FROM something MET/
  else if (indexes.length > 0 && /^FROM\s+\S+\s+/i.test(innerText) && metadataOverlap) {
    suggestions.push(_metadata.metadataSuggestion);
  }
  // FROM someth/
  // FROM something/
  // FROM something, /
  else if (indexes.length) {
    const sources = await getSources();
    const recommendedQuerySuggestions = await getRecommendedQueriesSuggestions(innerText);
    const additionalSuggestions = await (0, _helper.additionalSourcesSuggestions)(innerText, sources, indexes.map(({
      name
    }) => name), recommendedQuerySuggestions);
    suggestions.push(...additionalSuggestions);
  }
  return suggestions;
}