"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGrokCommand = void 0;
var _esql_parser = _interopRequireDefault(require("../../antlr/esql_parser"));
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGrokCommand = ctx => {
  const command = (0, _factories.createCommand)('grok', ctx);
  const primaryExpression = (0, _walkers.visitPrimaryExpression)(ctx.primaryExpression());
  const stringContext = ctx.string_();
  const pattern = stringContext.getToken(_esql_parser.default.QUOTED_STRING, 0);
  const doParseStringAndOptions = pattern && (0, _factories.textExistsAndIsValid)(pattern.getText());
  command.args.push(primaryExpression);
  if (doParseStringAndOptions) {
    const stringNode = (0, _factories.createLiteralString)(stringContext);
    command.args.push(stringNode);
  }
  return command;
};
exports.createGrokCommand = createGrokCommand;