"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDissectCommand = void 0;
var _esql_parser = _interopRequireDefault(require("../../antlr/esql_parser"));
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createDissectOptions = ctx => {
  if (!ctx) {
    return [];
  }
  const options = [];
  for (const optionCtx of ctx.commandOption_list()) {
    const option = (0, _factories.createOption)((0, _factories.sanitizeIdentifierString)(optionCtx.identifier()).toLowerCase(), optionCtx);
    options.push(option);
    // it can throw while accessing constant for incomplete commands, so try catch it
    try {
      const optionValue = (0, _walkers.getConstant)(optionCtx.constant());
      if (optionValue != null) {
        option.args.push(optionValue);
      }
    } catch (e) {
      // do nothing here
    }
  }
  return options;
};
const createDissectCommand = ctx => {
  const command = (0, _factories.createCommand)('dissect', ctx);
  const primaryExpression = (0, _walkers.visitPrimaryExpression)(ctx.primaryExpression());
  const stringContext = ctx.string_();
  const pattern = stringContext.getToken(_esql_parser.default.QUOTED_STRING, 0);
  const doParseStringAndOptions = pattern && (0, _factories.textExistsAndIsValid)(pattern.getText());
  command.args.push(primaryExpression);
  if (doParseStringAndOptions) {
    const stringNode = (0, _factories.createLiteralString)(stringContext);
    command.args.push(stringNode);
    command.args.push(...createDissectOptions(ctx.commandOptions()));
  }
  return command;
};
exports.createDissectCommand = createDissectCommand;