"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChangePointCommand = void 0;
var _builder = require("../../builder");
var _factories = require("../factories");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createChangePointCommand = ctx => {
  const value = (0, _factories.createColumn)(ctx._value);
  const command = (0, _factories.createCommand)('change_point', ctx, {
    value
  });
  command.args.push(value);
  if (ctx._key && ctx._key.getText()) {
    const key = (0, _factories.createColumn)(ctx._key);
    const option = _builder.Builder.option({
      name: 'on',
      args: [key]
    }, {
      location: (0, _helpers.getPosition)(ctx.ON().symbol, ctx._key.stop)
    });
    command.key = key;
    command.args.push(option);
  }
  if (ctx._targetType && ctx._targetPvalue) {
    const type = (0, _factories.createColumn)(ctx._targetType);
    const pvalue = (0, _factories.createColumn)(ctx._targetPvalue);
    const option = _builder.Builder.option({
      name: 'as',
      args: [type, pvalue]
    }, {
      location: (0, _helpers.getPosition)(ctx.AS().symbol, ctx._targetPvalue.stop)
    });
    command.target = {
      type,
      pvalue
    };
    command.args.push(option);
  }
  return command;
};
exports.createChangePointCommand = createChangePointCommand;