"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.remove = exports.options = exports.list = exports.insert = exports.findByName = exports.find = exports.args = exports.append = void 0;
var _visitor = require("../../../visitor");
var _args = _interopRequireWildcard(require("./args"));
exports.args = _args;
var _options = _interopRequireWildcard(require("./options"));
exports.options = _options;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns an iterator for all command AST nodes in the query. If a predicate is
 * provided, only commands that satisfy the predicate will be returned.
 *
 * @param ast Root AST node to search for commands.
 * @param predicate Optional predicate to filter commands.
 * @returns A list of commands found in the AST.
 */
const list = (ast, predicate) => {
  return new _visitor.Visitor().on('visitQuery', function* (ctx) {
    for (const cmd of ctx.commands()) {
      if (!predicate || predicate(cmd)) {
        yield cmd;
      }
    }
  }).visitQuery(ast);
};

/**
 * Returns the first command AST node at a given index in the query that
 * satisfies the predicate. If no index is provided, the first command found
 * will be returned.
 *
 * @param ast Root AST node to search for commands.
 * @param predicate Optional predicate to filter commands.
 * @param index The index of the command to return.
 * @returns The command found in the AST, if any.
 */
exports.list = list;
const find = (ast, predicate, index = 0) => {
  for (const cmd of list(ast, predicate)) {
    if (!index) {
      return cmd;
    }
    index--;
  }
  return undefined;
};

/**
 * Returns the first command AST node at a given index with a given name in the
 * query. If no index is provided, the first command found will be returned.
 *
 * @param ast Root AST node to search for commands.
 * @param commandName The name of the command to find.
 * @param index The index of the command to return.
 * @returns The command found in the AST, if any.
 */
exports.find = find;
const findByName = (ast, commandName, index = 0) => {
  return find(ast, cmd => cmd.name === commandName, index);
};

/**
 * Inserts a new command into the query AST node at the specified index. If the
 * `index` is out of bounds, the command will be appended to the end of the
 * command list.
 *
 * @param ast The root AST node.
 * @param command The command AST node to insert.
 * @param index The index to insert the command at.
 * @returns The index the command was inserted at.
 */
exports.findByName = findByName;
const insert = (ast, command, index = Infinity) => {
  const commands = ast.commands;
  if (index > commands.length || index < 0) {
    index = commands.length;
  }
  commands.splice(index, 0, command);
  return index;
};

/**
 * Adds a new command to the query AST node.
 *
 * @param ast The root AST node to append the command to.
 * @param command The command AST node to append.
 */
exports.insert = insert;
const append = (ast, command) => {
  ast.commands.push(command);
};
exports.append = append;
const remove = (ast, command) => {
  const cmds = ast.commands;
  const length = cmds.length;
  for (let i = 0; i < length; i++) {
    if (cmds[i] === command) {
      cmds.splice(i, 1);
      return true;
    }
  }
  return false;
};
exports.remove = remove;