"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sendRequest = async (httpClient, {
  path,
  method,
  body,
  query,
  version,
  asSystemRequest
}) => {
  try {
    const stringifiedBody = typeof body === 'string' ? body : JSON.stringify(body);
    const response = await httpClient[method](path, {
      body: stringifiedBody,
      query,
      version,
      asSystemRequest
    });
    return {
      data: response.data ? response.data : response,
      error: null
    };
  } catch (e) {
    var _e$response$data, _e$response;
    return {
      data: null,
      error: (_e$response$data = (_e$response = e.response) === null || _e$response === void 0 ? void 0 : _e$response.data) !== null && _e$response$data !== void 0 ? _e$response$data : e.body
    };
  }
};
exports.sendRequest = sendRequest;