"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityDefinitionRuntimePrivileges = exports.entityDefinitionDeletionPrivileges = exports.canManageEntityDefinition = exports.canEnableEntityDiscovery = exports.canDisableEntityDiscovery = exports.canDeleteEntityDefinition = exports.apiKeyCreationPrivileges = void 0;
var _constants_entities = require("../../../common/constants_entities");
var _saved_objects = require("../../saved_objects");
var _constants = require("../entities/built_in/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const canManageEntityDefinition = async (client, sourceIndices) => {
  const {
    has_all_requested: hasAllRequested
  } = await client.security.hasPrivileges({
    body: entityDefinitionRuntimePrivileges(sourceIndices)
  });
  return hasAllRequested;
};
exports.canManageEntityDefinition = canManageEntityDefinition;
const canDeleteEntityDefinition = async client => {
  const {
    has_all_requested: hasAllRequested
  } = await client.security.hasPrivileges({
    body: entityDefinitionDeletionPrivileges
  });
  return hasAllRequested;
};
exports.canDeleteEntityDefinition = canDeleteEntityDefinition;
const canManageAPIKey = async client => {
  const {
    has_all_requested: hasAllRequested
  } = await client.security.hasPrivileges({
    body: apiKeyCreationPrivileges
  });
  return hasAllRequested;
};
const canDeleteAPIKey = async client => {
  const {
    has_all_requested: hasAllRequested
  } = await client.security.hasPrivileges({
    body: apiKeyDeletionPrivileges
  });
  return hasAllRequested;
};
const canEnableEntityDiscovery = async client => {
  return Promise.all([canManageAPIKey(client), canManageEntityDefinition(client, _constants.BUILT_IN_ALLOWED_INDICES)]).then(results => results.every(Boolean));
};
exports.canEnableEntityDiscovery = canEnableEntityDiscovery;
const canDisableEntityDiscovery = async client => {
  return Promise.all([canDeleteAPIKey(client), canDeleteEntityDefinition(client)]).then(results => results.every(Boolean));
};
exports.canDisableEntityDiscovery = canDisableEntityDiscovery;
const entityDefinitionRuntimePrivileges = sourceIndices => ({
  cluster: ['manage_transform', 'manage_ingest_pipelines', 'manage_index_templates'],
  index: [{
    names: [_constants_entities.ENTITY_INTERNAL_INDICES_PATTERN],
    privileges: ['create_index', 'delete_index', 'index', 'create_doc', 'auto_configure', 'read']
  }, {
    names: [...sourceIndices, _constants_entities.ENTITY_INTERNAL_INDICES_PATTERN],
    privileges: ['read', 'view_index_metadata']
  }],
  application: [{
    application: 'kibana-.kibana',
    privileges: [`saved_object:${_saved_objects.SO_ENTITY_DEFINITION_TYPE}/*`],
    resources: ['*']
  }]
});
exports.entityDefinitionRuntimePrivileges = entityDefinitionRuntimePrivileges;
const entityDefinitionDeletionPrivileges = exports.entityDefinitionDeletionPrivileges = {
  cluster: ['manage_transform', 'manage_ingest_pipelines', 'manage_index_templates'],
  index: [{
    names: [_constants_entities.ENTITY_INTERNAL_INDICES_PATTERN],
    privileges: ['delete_index']
  }],
  application: [{
    application: 'kibana-.kibana',
    privileges: [`saved_object:${_saved_objects.SO_ENTITY_DEFINITION_TYPE}/delete`],
    resources: ['*']
  }]
};
const apiKeyCreationPrivileges = exports.apiKeyCreationPrivileges = {
  application: [{
    application: 'kibana-.kibana',
    privileges: [`saved_object:${_saved_objects.SO_ENTITY_DISCOVERY_API_KEY_TYPE}/*`],
    resources: ['*']
  }]
};
const apiKeyDeletionPrivileges = {
  application: [{
    application: 'kibana-.kibana',
    privileges: [`saved_object:${_saved_objects.SO_ENTITY_DISCOVERY_API_KEY_TYPE}/delete`],
    resources: ['*']
  }]
};