"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotFoundExceptionError = isNotFoundExceptionError;
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isNotFoundExceptionError(error) {
  return (0, _identify_exceptions.isResourceNotFoundException)(error) || (0, _identify_exceptions.isNotFoundException)(error) ||
  // @ts-expect-error error types incorrect
  (error === null || error === void 0 ? void 0 : error.statusCode) === 404;
}