"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recreateConnectorDocument = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _constants = require("../../../common/constants");
var _strip_search_prefix = require("../../../common/utils/strip_search_prefix");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recreateConnectorDocument = async (client, indexName) => {
  const document = (0, _searchConnectors.createConnectorDocument)({
    indexName,
    isNative: false,
    // The search index has already been created so we don't need the language, which we can't retrieve anymore anyway
    language: '',
    name: (0, _strip_search_prefix.stripSearchPrefix)(indexName),
    pipeline: null,
    serviceType: _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE
  });
  const result = await client.asCurrentUser.index({
    document: {
      ...document,
      status: _searchConnectors.ConnectorStatus.CONFIGURED
    },
    index: _searchConnectors.CONNECTORS_INDEX,
    refresh: 'wait_for'
  });
  return result._id;
};
exports.recreateConnectorDocument = recreateConnectorDocument;