"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchCrawlerCustomSchedulingKeysByIndexName = exports.fetchCrawlerCustomSchedulingByIndexName = void 0;
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CUSTOM_SCHEDULING = 'custom_scheduling';
const fetchCrawlerCustomSchedulingByIndexName = async (client, indexName) => {
  var _crawlerResult$hits$h;
  const crawlerResult = await client.asCurrentUser.search({
    index: _searchConnectors.CONNECTORS_INDEX,
    query: {
      term: {
        index_name: indexName
      }
    },
    _source: CUSTOM_SCHEDULING
  });
  const result = (_crawlerResult$hits$h = crawlerResult.hits.hits[0]) === null || _crawlerResult$hits$h === void 0 ? void 0 : _crawlerResult$hits$h._source;
  return result;
};
exports.fetchCrawlerCustomSchedulingByIndexName = fetchCrawlerCustomSchedulingByIndexName;
const fetchCrawlerCustomSchedulingKeysByIndexName = async (client, indexName) => {
  const crawlerCustomSchedules = await fetchCrawlerCustomSchedulingByIndexName(client, indexName);
  return crawlerCustomSchedules !== null && crawlerCustomSchedules !== void 0 && crawlerCustomSchedules.custom_scheduling ? Object.keys(crawlerCustomSchedules.custom_scheduling) : [];
};
exports.fetchCrawlerCustomSchedulingKeysByIndexName = fetchCrawlerCustomSchedulingKeysByIndexName;