"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _not_found = require("../../../shared/not_found");
var _telemetry = require("../../../shared/telemetry");
var _layout = require("../../components/layout");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotFound = ({
  isOrganization = true,
  pageChrome = []
}) => {
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [...pageChrome, '404'],
    customPageSections: true
  }, /*#__PURE__*/_react.default.createElement(_telemetry.SendWorkplaceSearchTelemetry, {
    action: "error",
    metric: "not_found"
  }), /*#__PURE__*/_react.default.createElement(_not_found.NotFoundPrompt, {
    backToLink: !isOrganization ? _routes.PRIVATE_SOURCES_PATH : '/',
    productSupportUrl: _constants.WORKPLACE_SEARCH_PLUGIN.SUPPORT_URL
  }));
};
exports.NotFound = NotFound;