"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFilterSourcesDropdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _groups_logic = require("../groups_logic");
var _sources_list = require("./sources_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_SOURCES_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.filterSources.buttonText', {
  defaultMessage: 'Sources'
});
const TableFilterSourcesDropdown = () => {
  const {
    addFilteredSource,
    removeFilteredSource,
    toggleFilterSourcesDropdown,
    closeFilterSourcesDropdown
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  const {
    contentSources,
    filterSourcesDropdownOpen,
    filteredSources
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const sourceIds = contentSources.map(({
    id
  }) => id);
  const filterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    onClick: toggleFilterSourcesDropdown,
    isDisabled: sourceIds.length === 0,
    isSelected: filterSourcesDropdownOpen,
    numFilters: sourceIds.length,
    hasActiveFilters: filteredSources.length > 0,
    numActiveFilters: filteredSources.length
  }, FILTER_SOURCES_BUTTON_TEXT);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: filterButton,
    isOpen: filterSourcesDropdownOpen,
    closePopover: closeFilterSourcesDropdown,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_sources_list.SourcesList, {
    contentSources: contentSources,
    filteredSources: filteredSources,
    addFilteredSource: addFilteredSource,
    removeFilteredSource: removeFilteredSource
  })));
};
exports.TableFilterSourcesDropdown = TableFilterSourcesDropdown;