"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _table_pagination_bar = require("../../../components/shared/table_pagination_bar");
var _groups_logic = require("../groups_logic");
var _clear_filters_link = require("./clear_filters_link");
var _group_row = require("./group_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GROUP_TABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupsTable.groupTableHeader', {
  defaultMessage: 'Group'
});
const GROUPS_PAGINATION_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupsTable.groupPagination.label', {
  defaultMessage: 'Groups'
});
const SOURCES_TABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupsTable.sourcesTableHeader', {
  defaultMessage: 'Content sources'
});
const GroupsTable = () => {
  const {
    setActivePage
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  const {
    groupsMeta: {
      page: {
        total_pages: totalPages,
        total_results: totalItems,
        current: activePage
      }
    },
    groups,
    hasFiltersSet
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const clearFiltersLink = hasFiltersSet ? /*#__PURE__*/_react.default.createElement(_clear_filters_link.ClearFiltersLink, null) : undefined;
  const paginationOptions = {
    itemLabel: GROUPS_PAGINATION_LABEL,
    totalPages,
    totalItems,
    activePage,
    clearFiltersLink,
    onChangePage: page => {
      // EUI component starts page at 0. API starts at 1.
      setActivePage(page + 1);
    }
  };
  const showPagination = totalPages > 1;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showPagination ? /*#__PURE__*/_react.default.createElement(_table_pagination_bar.TablePaginationBar, paginationOptions) : clearFiltersLink, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, GROUP_TABLE_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, SOURCES_TABLE_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right"
  }, _constants.ACTIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, groups.map((group, index) => /*#__PURE__*/_react.default.createElement(_group_row.GroupRow, (0, _extends2.default)({
    key: index
  }, group))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showPagination && /*#__PURE__*/_react.default.createElement(_table_pagination_bar.TablePaginationBar, (0, _extends2.default)({}, paginationOptions, {
    hideLabelCount: true
  })));
};
exports.GroupsTable = GroupsTable;