"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncFrequency = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _source_logic = require("../../source_logic");
var _frequency_item = require("./frequency_item");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncFrequency = () => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    schedule: {
      full: fullDuration,
      incremental: incrementalDuration,
      delete: deleteDuration,
      permissions: permissionsDuration,
      estimates: {
        full: fullEstimate,
        incremental: incrementalEstimate,
        delete: deleteEstimate,
        permissions: permissionsEstimate
      }
    }
  } = (0, _kea.useValues)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_frequency_item.FrequencyItem, {
    type: "full",
    label: _constants.FULL_SYNC_LABEL,
    description: _constants.FULL_SYNC_DESCRIPTION,
    duration: fullDuration,
    estimate: fullEstimate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_frequency_item.FrequencyItem, {
    type: "incremental",
    label: _constants.INCREMENTAL_SYNC_LABEL,
    description: _constants.INCREMENTAL_SYNC_DESCRIPTION,
    duration: incrementalDuration,
    estimate: incrementalEstimate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_frequency_item.FrequencyItem, {
    type: "delete",
    label: _constants.DELETION_SYNC_LABEL,
    description: _constants.DELETION_SYNC_DESCRIPTION,
    duration: deleteDuration,
    estimate: deleteEstimate
  }), permissionsDuration && permissionsEstimate && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_frequency_item.FrequencyItem, {
    type: "permissions",
    label: _constants.PERMISSIONS_SYNC_LABEL,
    description: _constants.PERMISSIONS_SYNC_DESCRIPTION,
    duration: permissionsDuration,
    estimate: permissionsEstimate
  })));
};
exports.SyncFrequency = SyncFrequency;