"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubtitleField = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubtitleField = ({
  result,
  subtitleField,
  subtitleFieldHover
}) => /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "SubtitleField",
  className: (0, _classnames.default)('example-result-content__subtitle', {
    'example-result-field-hover': subtitleFieldHover
  })
}, subtitleField ? /*#__PURE__*/_react.default.createElement("div", {
  className: "eui-textTruncate"
}, result[subtitleField]) : /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "DefaultSubtitleLabel",
  className: "example-result-content-placeholder"
}, _constants.SUBTITLE_LABEL));
exports.SubtitleField = SubtitleField;