"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _source_icon = require("../../../../components/shared/source_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceHeader = ({
  name,
  serviceType,
  categories = []
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
    serviceType: serviceType,
    name: name,
    className: "adding-a-source__icon",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default"
  }, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, serviceType === 'external' ? _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.addSource.addSourceHeader.externalConnectorLabel', {
    defaultMessage: 'Externally deployed connector package'
  }) : categories.map(category => (0, _lodash.startCase)(category)).join(', ')))));
};
exports.AddSourceHeader = AddSourceHeader;