"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveCustom = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../../../../shared/react_router_helpers");
var _app_logic = require("../../../../../app_logic");
var _routes = require("../../../../../routes");
var _custom_source_deployment = require("../../custom_source_deployment");
var _add_source_header = require("../add_source_header");
var _constants = require("../constants");
var _add_custom_source_logic = require("./add_custom_source_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SaveCustom = ({
  sourceData
}) => {
  const {
    newCustomSource
  } = (0, _kea.useValues)(_add_custom_source_logic.AddCustomSourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    serviceType,
    baseServiceType,
    name,
    categories = []
  } = sourceData;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: baseServiceType !== null && baseServiceType !== void 0 ? baseServiceType : serviceType,
    categories: categories
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    style: {
      marginTop: 'auto',
      marginBottom: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.saveCustom.heading', {
    defaultMessage: '{name} Created',
    values: {
      name: newCustomSource.name
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, _constants.SAVE_CUSTOM_BODY1))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    size: "m",
    color: "primary",
    fill: true,
    to: (0, _routes.getSourcesPath)(_routes.SOURCES_PATH, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.saveCustom.configureNewSourceButtonLabel",
    defaultMessage: "Configure a new content source"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_custom_source_deployment.CustomSourceDeployment, {
    source: newCustomSource,
    baseServiceType: baseServiceType
  }))), baseServiceType && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "FeedbackCallout",
    heading: "h3",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/kibana/feedback",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.sources.feedbackLinkLabel",
      defaultMessage: "Have feedback about deploying a {name} connector? Let us know.",
      values: {
        name
      }
    })),
    iconType: "email"
  })))));
};
exports.SaveCustom = SaveCustom;