"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_API_KEY_LABEL = exports.NAME_TITLE = exports.KEY_TITLE = exports.HIDE_API_KEY_LABEL = exports.ENDPOINT_TITLE = exports.DELETE_MESSAGE = exports.DELETE_API_KEY_BUTTON_DESCRIPTION = exports.CREATE_MESSAGE = exports.CREATE_KEY_BUTTON_LABEL = exports.COPY_API_KEY_BUTTON_LABEL = exports.COPY_API_ENDPOINT_BUTTON_LABEL = exports.COPIED_TOOLTIP = exports.API_KEY_NAME_PLACEHOLDER = exports.API_KEY_FORM_LABEL = exports.API_KEY_FORM_HELP_TEXT = exports.API_KEY_FLYOUT_TITLE = exports.API_KEYS_EMPTY_TITLE = exports.API_KEYS_EMPTY_BUTTON_LABEL = exports.API_KEYS_EMPTY_BODY = exports.API_KEYS_CONFIRM_DELETE_TITLE = exports.API_KEYS_CONFIRM_DELETE_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_KEY_BUTTON_LABEL = exports.CREATE_KEY_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.createKey.buttonLabel', {
  defaultMessage: 'Create key'
});
const ENDPOINT_TITLE = exports.ENDPOINT_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.endpointTitle', {
  defaultMessage: 'Endpoint'
});
const NAME_TITLE = exports.NAME_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.nameTitle', {
  defaultMessage: 'Name'
});
const KEY_TITLE = exports.KEY_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.keyTitle', {
  defaultMessage: 'Key'
});
const COPIED_TOOLTIP = exports.COPIED_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.copied.tooltip', {
  defaultMessage: 'Copied'
});
const COPY_API_ENDPOINT_BUTTON_LABEL = exports.COPY_API_ENDPOINT_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.copyApiEndpoint.buttonLabel', {
  defaultMessage: 'Copy API Endpoint to clipboard.'
});
const COPY_API_KEY_BUTTON_LABEL = exports.COPY_API_KEY_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.copyApiKey.buttonLabel', {
  defaultMessage: 'Copy API Key to clipboard.'
});
const DELETE_API_KEY_BUTTON_DESCRIPTION = exports.DELETE_API_KEY_BUTTON_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.deleteApiKey.buttonDescription', {
  defaultMessage: 'Delete API key'
});
const CREATE_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.createdMessage', {
  defaultMessage: "API key ''{name}'' was created",
  values: {
    name
  }
});
exports.CREATE_MESSAGE = CREATE_MESSAGE;
const DELETE_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.deletedMessage', {
  defaultMessage: "API key ''{name}'' was deleted",
  values: {
    name
  }
});
exports.DELETE_MESSAGE = DELETE_MESSAGE;
const API_KEY_FLYOUT_TITLE = exports.API_KEY_FLYOUT_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.flyoutTitle', {
  defaultMessage: 'Create a new key'
});
const API_KEY_FORM_LABEL = exports.API_KEY_FORM_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.formLabel', {
  defaultMessage: 'Key name'
});
const API_KEY_FORM_HELP_TEXT = name => _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.formHelpText', {
  defaultMessage: 'Your key will be named: {name}',
  values: {
    name
  }
});
exports.API_KEY_FORM_HELP_TEXT = API_KEY_FORM_HELP_TEXT;
const API_KEY_NAME_PLACEHOLDER = exports.API_KEY_NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.namePlaceholder', {
  defaultMessage: 'i.e., my-api-key'
});
const SHOW_API_KEY_LABEL = exports.SHOW_API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.showApiKeyLabel', {
  defaultMessage: 'Show API Key'
});
const HIDE_API_KEY_LABEL = exports.HIDE_API_KEY_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.hideApiKeyLabel', {
  defaultMessage: 'Hide API Key'
});
const API_KEYS_EMPTY_TITLE = exports.API_KEYS_EMPTY_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.emptyTitle', {
  defaultMessage: 'Create your first API key'
});
const API_KEYS_EMPTY_BODY = exports.API_KEYS_EMPTY_BODY = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.emptyBody', {
  defaultMessage: 'Allow applications to access Elastic Workplace Search on your behalf.'
});
const API_KEYS_EMPTY_BUTTON_LABEL = exports.API_KEYS_EMPTY_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.emptyButtonLabel', {
  defaultMessage: 'Learn about API keys'
});
const API_KEYS_CONFIRM_DELETE_TITLE = exports.API_KEYS_CONFIRM_DELETE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.confirmDeleteTitle', {
  defaultMessage: 'Delete API key'
});
const API_KEYS_CONFIRM_DELETE_LABEL = exports.API_KEYS_CONFIRM_DELETE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.apiKeys.confirmDeleteLabel', {
  defaultMessage: 'Are you sure you want to delete this API key? This action cannot be undone.'
});