"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _source_icons = require("../assets/source_icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceIcon = ({
  name,
  serviceType,
  className,
  size,
  iconAsBase64
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: iconAsBase64 ? `data:image/png;base64,${iconAsBase64}` : _source_icons.images[(0, _lodash.camelCase)(serviceType)],
  title: `${name} logo`,
  className: className,
  size: size
});
exports.SourceIcon = SourceIcon;