"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMetaPageIndex = exports.handlePageChange = exports.convertMetaToPagination = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Note: App Search's API pages start at 1 & EuiBasicTables' pages start at 0
 * These helpers both automatically handle off-by-1 conversion in addition to
 * automatically converting our snake_cased API meta to camelCased EUI props
 */

const convertMetaToPagination = meta => ({
  pageIndex: meta.page.current - 1,
  pageSize: meta.page.size,
  totalItemCount: meta.page.total_results
});
exports.convertMetaToPagination = convertMetaToPagination;
const handlePageChange = paginationCallback => ({
  page: {
    index
  }
}) => {
  paginationCallback(index + 1);
};

/**
 * Helper for updating Kea `meta` state without mutating nested objs
 */
exports.handlePageChange = handlePageChange;
const updateMetaPageIndex = (oldState, newPageIndex) => {
  const newMetaState = {
    ...oldState,
    page: {
      ...oldState.page
    }
  };
  newMetaState.page.current = newPageIndex;
  return newMetaState;
};
exports.updateMetaPageIndex = updateMetaPageIndex;