"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupInstructions = ({
  productName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  headingElement: "h2",
  steps: [{
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.step1.title', {
      defaultMessage: 'Add your {productName} host URL to your Kibana configuration',
      values: {
        productName
      }
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.step1.instruction1",
      defaultMessage: "In your {configFile} file, set {configSetting} to the URL of your {productName} instance. For example:",
      values: {
        productName,
        configFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "config/kibana.yml"),
        configSetting: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "enterpriseSearch.host")
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "yml"
    }, "enterpriseSearch.host: 'http://localhost:3002'"))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.step2.title', {
      defaultMessage: 'Reload your Kibana instance'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.step2.instruction1",
      defaultMessage: "Restart Kibana to pick up the configuration changes from the previous step."
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.step3.title', {
      defaultMessage: 'Troubleshooting issues'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      buttonContent: _i18n.i18n.translate('xpack.enterpriseSearch.troubleshooting.differentEsClusters.title', {
        defaultMessage: '{productName} and Kibana are on different Elasticsearch clusters',
        values: {
          productName
        }
      }),
      id: "differentEsClusters",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.troubleshooting.differentEsClusters.description",
      defaultMessage: "This plugin does not currently support {productName} and Kibana running on different clusters.",
      values: {
        productName
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.troubleshooting.setup.description",
      defaultMessage: "For help with other common setup issues, read our {link} guide.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.enterpriseSearchTroubleshootSetup,
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.enterpriseSearch.troubleshooting.setup.documentationLinkLabel', {
          defaultMessage: 'Troubleshoot Enterprise Search setup'
        }))
      }
    }))))
  }]
}));
exports.SetupInstructions = SetupInstructions;