"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _doc_links = require("../doc_links");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SMTP_URL = `${_doc_links.docLinks.enterpriseSearchMailService}`;
const UserSelector = ({
  isNewUser,
  smtpSettingsPresent,
  userFormUserIsExisting,
  elasticsearchUsers,
  elasticsearchUser,
  roleTypes,
  roleType,
  setUserExisting,
  setElasticsearchUsernameValue,
  setElasticsearchEmailValue,
  handleRoleChange,
  handleUsernameSelectChange
}) => {
  const roleOptions = roleTypes.map(role => ({
    id: role,
    text: role
  }));
  const usernameOptions = elasticsearchUsers.map(({
    username
  }) => ({
    id: username,
    text: username
  }));
  const hasElasticsearchUsers = elasticsearchUsers.length > 0;
  const showNewUserExistingUserControls = userFormUserIsExisting && hasElasticsearchUsers;
  const smptHelpText = !smtpSettingsPresent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants2.SMTP_CALLOUT_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: SMTP_URL,
    target: "_blank"
  }, _constants2.SMTP_LINK_LABEL));
  const roleSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.ROLE_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: _constants2.ROLE_LABEL,
    "data-test-subj": "RoleSelect",
    options: roleOptions,
    value: roleType,
    onChange: e => handleRoleChange(e.target.value)
  }));
  const emailInput = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.EMAIL_LABEL,
    helpText: smptHelpText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: _constants.EMAIL_LABEL,
    "data-test-subj": "EmailInput",
    value: elasticsearchUser.email,
    onChange: e => setElasticsearchEmailValue(e.target.value)
  }));
  const usernameAndEmailControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.USERNAME_LABEL,
    helpText: !elasticsearchUser.username && _constants2.REQUIRED_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: _constants.USERNAME_LABEL,
    disabled: !isNewUser,
    "data-test-subj": "UsernameInput",
    value: elasticsearchUser.username,
    onChange: e => setElasticsearchUsernameValue(e.target.value)
  })), elasticsearchUser.email !== null && emailInput, roleSelect);
  const existingUserControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.USERNAME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "Username select",
    "data-test-subj": "UsernameSelect",
    options: usernameOptions,
    value: elasticsearchUser.username,
    disabled: !hasElasticsearchUsers,
    onChange: e => handleUsernameSelectChange(e.target.value)
  })), roleSelect);
  const newUserControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), usernameAndEmailControls);
  const createUserControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: !hasElasticsearchUsers && _constants2.USERNAME_NO_USERS_TEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: "existingUser",
    "data-test-subj": "ExistingUserRadio",
    label: _constants2.EXISTING_USER_LABEL,
    checked: userFormUserIsExisting && hasElasticsearchUsers,
    onChange: () => setUserExisting(true),
    disabled: !hasElasticsearchUsers
  })), showNewUserExistingUserControls && existingUserControls, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: "newUser",
    "data-test-subj": "NewUserRadio",
    label: _constants2.NEW_USER_LABEL,
    checked: !userFormUserIsExisting || !hasElasticsearchUsers,
    onChange: () => setUserExisting(false)
  }), !showNewUserExistingUserControls && newUserControls);
  return isNewUser ? createUserControls : usernameAndEmailControls;
};
exports.UserSelector = UserSelector;