"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestConnectionPanelContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _searchApiPanels = require("@kbn/search-api-panels");
var _languages = require("../languages/languages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestConnectionPanelContent = ({
  assetBasePath,
  codeArgs,
  selectedLanguage,
  setSelectedLanguage
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    languages: _languages.languageDefinitions,
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'testConnection', codeArgs),
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('testConnection'),
    selectedLanguage: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: assetBasePath,
    application: services.application,
    sharePlugin: services.share
  });
};
exports.TestConnectionPanelContent = TestConnectionPanelContent;