"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setSuccessMessage = exports.setQueuedSuccessMessage = exports.setQueuedErrorMessage = exports.setErrorMessage = exports.flashSuccessToast = exports.flashErrorToast = exports.clearFlashMessages = void 0;
var _constants = require("./constants");
var _flash_messages_logic = require("./flash_messages_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setSuccessMessage = message => {
  _flash_messages_logic.FlashMessagesLogic.actions.setFlashMessages({
    type: 'success',
    message
  });
};
exports.setSuccessMessage = setSuccessMessage;
const setErrorMessage = message => {
  _flash_messages_logic.FlashMessagesLogic.actions.setFlashMessages({
    type: 'error',
    message
  });
};
exports.setErrorMessage = setErrorMessage;
const setQueuedSuccessMessage = message => {
  _flash_messages_logic.FlashMessagesLogic.actions.setQueuedMessages({
    type: 'success',
    message
  });
};
exports.setQueuedSuccessMessage = setQueuedSuccessMessage;
const setQueuedErrorMessage = message => {
  _flash_messages_logic.FlashMessagesLogic.actions.setQueuedMessages({
    type: 'error',
    message
  });
};
exports.setQueuedErrorMessage = setQueuedErrorMessage;
const clearFlashMessages = () => {
  _flash_messages_logic.FlashMessagesLogic.actions.clearFlashMessages();
};
exports.clearFlashMessages = clearFlashMessages;
const flashSuccessToast = (message, toastOptions = {}) => {
  _flash_messages_logic.FlashMessagesLogic.values.notifications.toasts.add({
    ..._constants.FLASH_MESSAGE_TYPES.success,
    ...toastOptions,
    title: message
  });
};
exports.flashSuccessToast = flashSuccessToast;
const flashErrorToast = (message, toastOptions = {}) => {
  _flash_messages_logic.FlashMessagesLogic.values.notifications.toasts.add({
    ..._constants.FLASH_MESSAGE_TYPES.error,
    ...toastOptions,
    title: message
  });
};
exports.flashErrorToast = flashErrorToast;