"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDecodedParams = exports.generateEncodedPath = exports.encodePathParams = void 0;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encodePathParams = pathParams => {
  const encodedParams = {};
  Object.entries(pathParams).map(([key, value]) => {
    encodedParams[key] = encodeURIComponent(value);
  });
  return encodedParams;
};
exports.encodePathParams = encodePathParams;
const generateEncodedPath = (path, pathParams) => {
  return (0, _reactRouterDom.generatePath)(path, encodePathParams(pathParams));
};
exports.generateEncodedPath = generateEncodedPath;
const useDecodedParams = () => {
  const decodedParams = {};
  const params = (0, _reactRouterDom.useParams)();
  Object.entries(params).map(([key, value]) => {
    decodedParams[key] = decodeURIComponent(value);
  });
  return decodedParams;
};
exports.useDecodedParams = useDecodedParams;