"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _product_card = require("../product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearchProductCard = ({
  hasBorder = true,
  hasShadow = true,
  isWorkplaceSearchAdmin
}) => /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
  hasBorder: hasBorder,
  hasShadow: hasShadow,
  description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.productCardDescription', {
    defaultMessage: 'Tailored for internal business teams, Workplace Search enables instant connectivity to popular productivity tools and third-party sources into a single, unified platform.'
  }),
  emptyCta: true,
  cta: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.cta', {
    defaultMessage: 'Explore'
  }),
  icon: "logoWorkplaceSearch",
  name: _constants.WORKPLACE_SEARCH_PLUGIN.NAME,
  productId: _constants.WORKPLACE_SEARCH_PLUGIN.ID,
  url: isWorkplaceSearchAdmin ? _constants.WORKPLACE_SEARCH_PLUGIN.URL : _constants.WORKPLACE_SEARCH_PLUGIN.NON_ADMIN_URL
});
exports.WorkplaceSearchProductCard = WorkplaceSearchProductCard;