"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorStatusToColor = connectorStatusToColor;
exports.connectorStatusToText = connectorStatusToText;
exports.isLastSeenOld = exports.getConnectorLastSeenError = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isLastSeenOld = connector => connector.last_seen ? (0, _moment.default)(connector.last_seen).isBefore((0, _moment.default)().subtract(30, 'minutes')) : false;
exports.isLastSeenOld = isLastSeenOld;
const getConnectorLastSeenError = connector => {
  return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.lastSeenError.label', {
    defaultMessage: 'Your connector has not checked in for over 30 minutes. (last_seen: {lastSeen})',
    values: {
      lastSeen: connector.last_seen
    }
  });
};
exports.getConnectorLastSeenError = getConnectorLastSeenError;
const incompleteText = _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.incomplete.label', {
  defaultMessage: 'Incomplete'
});
function connectorStatusToText(connector) {
  const hasIndexName = !!connector.index_name;
  const connectorStatus = connector.status;
  if (connectorStatus === _searchConnectors.ConnectorStatus.CREATED || connectorStatus === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.needsConfig.label', {
      defaultMessage: 'Needs Configuration'
    });
  }
  if (connector.last_sync_status === _searchConnectors.SyncStatus.ERROR || connector.last_access_control_sync_status === _searchConnectors.SyncStatus.ERROR || connector.last_sync_error != null || connector.last_access_control_sync_error != null) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.syncFailure.label', {
      defaultMessage: 'Sync Failure'
    });
  }
  if (isLastSeenOld(connector) || connectorStatus === _searchConnectors.ConnectorStatus.ERROR) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.connectorFailure.label', {
      defaultMessage: 'Connector Failure'
    });
  }
  if (!hasIndexName) {
    return incompleteText;
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONFIGURED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.configured.label', {
      defaultMessage: 'Configured'
    });
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONNECTED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.connected.label', {
      defaultMessage: 'Connected'
    });
  }
  return incompleteText;
}
function connectorStatusToColor(connector) {
  const hasIndexName = !!connector.index_name;
  const connectorStatus = connector.status;
  if (!hasIndexName) {
    return 'warning';
  }
  if (isLastSeenOld(connector) || connectorStatus === _searchConnectors.ConnectorStatus.ERROR || connector.last_sync_status === _searchConnectors.SyncStatus.ERROR || connector.last_access_control_sync_status === _searchConnectors.SyncStatus.ERROR || connector.last_sync_error != null || connector.last_access_control_sync_error != null) {
    return 'danger';
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONNECTED) {
    return 'success';
  }
  return 'warning';
}