"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _connector_view_logic = require("../connector_detail/connector_view_logic");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _search_index = require("./search_index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexRouter = () => {
  const indexName = decodeURIComponent((0, _reactRouterDom.useParams)().indexName);
  const {
    setIndexName
  } = (0, _kea.useActions)(_index_name_logic.IndexNameLogic);
  const {
    startFetchIndexPoll,
    stopFetchIndexPoll,
    resetFetchIndexApi
  } = (0, _kea.useActions)(_index_view_logic.IndexViewLogic);
  const {
    connector
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    startConnectorPoll,
    stopConnectorPoll,
    fetchConnectorApiReset
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  (0, _react.useEffect)(() => {
    const unmountName = _index_name_logic.IndexNameLogic.mount();
    const unmountView = _index_view_logic.IndexViewLogic.mount();
    const unmountConnectorView = _connector_view_logic.ConnectorViewLogic.mount();
    return () => {
      stopFetchIndexPoll();
      stopConnectorPoll();
      resetFetchIndexApi();
      fetchConnectorApiReset();
      unmountName();
      unmountView();
      unmountConnectorView();
    };
  }, []);
  (0, _react.useEffect)(() => {
    stopConnectorPoll();
    fetchConnectorApiReset();
    if (connector !== null && connector !== void 0 && connector.id) {
      startConnectorPoll(connector.id);
    }
  }, [connector === null || connector === void 0 ? void 0 : connector.id]);
  (0, _react.useEffect)(() => {
    stopFetchIndexPoll();
    resetFetchIndexApi();
    setIndexName(indexName);
    if (indexName) {
      startFetchIndexPoll(indexName);
    } else {
      stopFetchIndexPoll();
    }
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_PATH,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_TAB_DETAIL_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_TAB_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.OLD_SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH,
    to: `${_routes.SEARCH_INDEX_PATH}/domain_management/:domainId}`
  }));
};
exports.SearchIndexRouter = SearchIndexRouter;