"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextExpansionDismissButton = exports.TextExpansionCallOut = exports.FineTuneModelsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../shared/kibana");
var _index_view_logic = require("../../../index_view_logic");
var _utils = require("../utils");
var _deploy_model = require("./deploy_model");
var _model_deployed = require("./model_deployed");
var _model_deployment_in_progress = require("./model_deployment_in_progress");
var _model_started = require("./model_started");
var _text_expansion_callout_data = require("./text_expansion_callout_data");
var _text_expansion_callout_logic = require("./text_expansion_callout_logic");
var _text_expansion_errors = require("./text_expansion_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextExpansionDismissButton = ({
  dismiss
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.dismissButton', {
      defaultMessage: 'Dismiss ELSER call out'
    }),
    iconType: "cross",
    onClick: dismiss
  });
};
exports.TextExpansionDismissButton = TextExpansionDismissButton;
const FineTuneModelsButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_utils.TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.fineTuneModelButton', {
  defaultMessage: 'Fine-tune performance'
}));
exports.FineTuneModelsButton = FineTuneModelsButton;
const TextExpansionCallOut = props => {
  const {
    dismiss,
    isCompact,
    isDismissable,
    show
  } = (0, _text_expansion_callout_data.useTextExpansionCallOutData)(props);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCreateButtonDisabled,
    isModelDownloadInProgress,
    isModelDownloaded,
    isModelRunningSingleThreaded,
    isModelStarted,
    textExpansionError,
    isStartButtonDisabled
  } = (0, _kea.useValues)(_text_expansion_callout_logic.TextExpansionCalloutLogic);
  if (textExpansionError) return /*#__PURE__*/_react.default.createElement(_text_expansion_errors.TextExpansionErrors, {
    error: textExpansionError
  });
  if (!show) return null;
  if (isModelDownloadInProgress) {
    return /*#__PURE__*/_react.default.createElement(_model_deployment_in_progress.ModelDeploymentInProgress, {
      dismiss: dismiss,
      isDismissable: isDismissable
    });
  } else if (isModelDownloaded) {
    return /*#__PURE__*/_react.default.createElement(_model_deployed.ModelDeployed, {
      dismiss: dismiss,
      ingestionMethod: ingestionMethod,
      isDismissable: isDismissable,
      isStartButtonDisabled: isStartButtonDisabled
    });
  } else if (isModelStarted) {
    return /*#__PURE__*/_react.default.createElement(_model_started.ModelStarted, {
      dismiss: dismiss,
      isCompact: isCompact,
      isDismissable: isDismissable,
      isSingleThreaded: isModelRunningSingleThreaded
    });
  }
  return /*#__PURE__*/_react.default.createElement(_deploy_model.DeployModel, {
    dismiss: dismiss,
    ingestionMethod: ingestionMethod,
    isDismissable: isDismissable,
    isCreateButtonDisabled: isCreateButtonDisabled
  });
};
exports.TextExpansionCallOut = TextExpansionCallOut;