"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _utils = require("../../../../api/crawler/utils");
var _index_name_logic = require("../../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailLogic = exports.CrawlDetailLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'crawler', 'crawl_detail_logic'],
  actions: {
    closeFlyout: true,
    fetchCrawlRequest: requestId => ({
      requestId
    }),
    onRecieveCrawlRequest: crawlRequestFromServer => ({
      crawlRequestFromServer
    }),
    setSelectedTab: selectedTab => ({
      selectedTab
    })
  },
  reducers: {
    crawlRequest: [null, {
      onRecieveCrawlRequest: (_, {
        crawlRequestFromServer
      }) => (0, _utils.crawlRequestWithDetailsServerToClient)(crawlRequestFromServer)
    }],
    crawlRequestFromServer: [null, {
      onRecieveCrawlRequest: (_, {
        crawlRequestFromServer
      }) => crawlRequestFromServer
    }],
    dataLoading: [true, {
      fetchCrawlRequest: () => true,
      onRecieveCrawlRequest: () => false
    }],
    flyoutClosed: [true, {
      fetchCrawlRequest: () => false,
      closeFlyout: () => true
    }],
    selectedTab: ['preview', {
      fetchCrawlRequest: () => 'preview',
      setSelectedTab: (_, {
        selectedTab
      }) => selectedTab
    }]
  },
  listeners: ({
    actions
  }) => ({
    fetchCrawlRequest: async ({
      requestId
    }) => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        indexName
      } = _index_name_logic.IndexNameLogic.values;
      try {
        const response = await http.get(`/internal/enterprise_search/indices/${indexName}/crawler/crawl_requests/${requestId}`);
        actions.onRecieveCrawlRequest(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});