"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCrawlerCustomScheduling = exports.PostCustomSchedulingApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postCrawlerCustomScheduling = async ({
  indexName,
  customScheduling
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/custom_scheduling`;
  await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(Object.fromEntries(customScheduling))
  });
};
exports.postCrawlerCustomScheduling = postCrawlerCustomScheduling;
const PostCustomSchedulingApiLogic = exports.PostCustomSchedulingApiLogic = (0, _create_api_logic.createApiLogic)(['post_crawler_custom_scheduling_api_logic'], postCrawlerCustomScheduling, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.postCrawlerCustomSchedulingSuccess.message', {
    defaultMessage: 'Successfully saved crawler custom scheduling.'
  })
});