"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSyncRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_filtering_logic = require("./connector_filtering_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedSyncRules = () => {
  const {
    hasJsonValidationError: hasError,
    localAdvancedSnippet,
    advancedSnippet
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    setLocalAdvancedSnippet
  } = (0, _kea.useActions)(_connector_filtering_logic.ConnectorFilteringLogic);
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  const isLocalSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(localAdvancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connector.syncRules.advancedRules.title', {
      defaultMessage: 'Advanced rules'
    }),
    isInvalid: hasError,
    error: hasError ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connector.syncRules.advancedRules.error', {
      defaultMessage: 'JSON format is invalid'
    }) : undefined,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    isCopyable: true,
    languageId: "json",
    options: {
      detectIndentation: true,
      lineNumbers: 'on',
      tabSize: 2
    },
    value: localAdvancedSnippet,
    onChange: value => {
      setLocalAdvancedSnippet(value);
    },
    height: "250px",
    width: "100%"
  })), (!isAdvancedSnippetEmpty || !isLocalSnippetEmpty) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedTabCallout.title', {
      defaultMessage: 'Configuration warning'
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.editSyncRulesFlyout.advancedTablCallout.description",
    defaultMessage: "This advanced sync rule might override some configuration fields."
  }))));
};
exports.AdvancedSyncRules = AdvancedSyncRules;