"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodApiLogic = void 0;
var _kea = require("kea");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _create_api_index_api_logic = require("../../../api/index/create_api_index_api_logic");
var _routes = require("../../../routes");
var _search_index = require("../../search_index/search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodApiLogic = exports.MethodApiLogic = (0, _kea.kea)({
  connect: {
    actions: [_create_api_index_api_logic.CreateApiIndexApiLogic, ['apiSuccess', 'makeRequest']],
    values: [_create_api_index_api_logic.CreateApiIndexApiLogic, ['status']]
  },
  listeners: {
    apiSuccess: ({
      indexName
    }) => {
      _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName,
        tabId: _search_index.SearchIndexTabId.OVERVIEW
      }));
    }
  },
  path: ['enterprise_search', 'method_api']
});