"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simulateExistingMlInferencePipeline = exports.SimulateExistingMlInterfacePipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const simulateExistingMlInferencePipeline = async ({
  docs,
  indexName,
  pipelineName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/ml_inference/pipeline_processors/simulate/${pipelineName}`;
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      docs
    })
  });
};
exports.simulateExistingMlInferencePipeline = simulateExistingMlInferencePipeline;
const SimulateExistingMlInterfacePipelineApiLogic = exports.SimulateExistingMlInterfacePipelineApiLogic = (0, _create_api_logic.createApiLogic)(['simulate_existing_ml_inference_pipeline_api_logic'], simulateExistingMlInferencePipeline);