"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchUnconfigured = exports.AppSearchConfigured = exports.AppSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _http = require("../shared/http");
var _kibana = require("../shared/kibana");
var _endpoints_header_action = require("../shared/layout/endpoints_header_action");
var _version_mismatch = require("../shared/version_mismatch");
var _app_logic = require("./app_logic");
var _credentials = require("./components/credentials");
var _engine = require("./components/engine");
var _engine_creation = require("./components/engine_creation");
var _engines = require("./components/engines");
var _error_connecting = require("./components/error_connecting");
var _layout = require("./components/layout");
var _library = require("./components/library");
var _meta_engine_creation = require("./components/meta_engine_creation");
var _not_found = require("./components/not_found");
var _role_mappings = require("./components/role_mappings");
var _settings = require("./components/settings");
var _setup_guide = require("./components/setup_guide");
var _routes = require("./routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppSearch = props => {
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    enterpriseSearchVersion,
    kibanaVersion
  } = props;
  const incompatibleVersions = (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion);
  const showView = () => {
    if (!config.host) {
      return /*#__PURE__*/_react.default.createElement(AppSearchUnconfigured, null);
    } else if (incompatibleVersions) {
      return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
        enterpriseSearchVersion: enterpriseSearchVersion,
        kibanaVersion: kibanaVersion
      });
    } else if (errorConnectingMessage) {
      return /*#__PURE__*/_react.default.createElement(_error_connecting.ErrorConnecting, null);
    }
    return /*#__PURE__*/_react.default.createElement(AppSearchConfigured, props);
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SETUP_GUIDE_PATH
  }, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, showView()));
};
exports.AppSearch = AppSearch;
const AppSearchUnconfigured = () => {
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  renderHeaderActions(_endpoints_header_action.EndpointsHeaderAction);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _routes.SETUP_GUIDE_PATH
  })));
};
exports.AppSearchUnconfigured = AppSearchUnconfigured;
const AppSearchConfigured = props => {
  const {
    showGateForm,
    myRole: {
      canManageEngines,
      canManageMetaEngines,
      canViewSettings,
      canViewAccountCredentials,
      canViewRoleMappings
    }
  } = (0, _kea.useValues)((0, _app_logic.AppLogic)(props));
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    renderHeaderActions(_layout.KibanaHeaderActions);
  }, []);
  return !showGateForm ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, process.env.NODE_ENV === 'development' && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.LIBRARY_PATH
  }, /*#__PURE__*/_react.default.createElement(_library.Library, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _routes.ENGINES_PATH
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINES_PATH
  }, /*#__PURE__*/_react.default.createElement(_engines.EnginesOverview, null)), canManageEngines && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_CREATION_PATH
  }, /*#__PURE__*/_react.default.createElement(_engine_creation.EngineCreation, null)), canManageMetaEngines && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.META_ENGINE_CREATION_PATH
  }, /*#__PURE__*/_react.default.createElement(_meta_engine_creation.MetaEngineCreation, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_PATH
  }, /*#__PURE__*/_react.default.createElement(_engine.EngineRouter, null)), canViewSettings && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SETTINGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_settings.Settings, null)), canViewAccountCredentials && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.CREDENTIALS_PATH
  }, /*#__PURE__*/_react.default.createElement(_credentials.Credentials, null)), canViewRoleMappings && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.USERS_AND_ROLES_PATH
  }, /*#__PURE__*/_react.default.createElement(_role_mappings.RoleMappings, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null))) : /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _routes.ENGINES_PATH
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINES_PATH
  }, /*#__PURE__*/_react.default.createElement(_engines.EnginesOverview, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null)));
};
exports.AppSearchConfigured = AppSearchConfigured;