"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisabledFieldsBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DisabledFieldsBody = () => {
  const {
    schemaConflicts
  } = (0, _kea.useValues)(_.ResultSettingsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(schemaConflicts).map(fieldName => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: fieldName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    colSpan: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "ResultSettingFieldName"
  }, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.fieldTypeConflictText', {
    defaultMessage: 'Field-type conflict'
  }))))));
};
exports.DisabledFieldsBody = DisabledFieldsBody;