"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultToken = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../shared/schema/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldTypeToTokenMap = {
  [_types.SchemaType.Text]: 'tokenString',
  [_types.InternalSchemaType.String]: 'tokenString',
  [_types.SchemaType.Number]: 'tokenNumber',
  [_types.InternalSchemaType.Float]: 'tokenNumber',
  [_types.SchemaType.Geolocation]: 'tokenGeo',
  [_types.InternalSchemaType.Location]: 'tokenGeo',
  [_types.SchemaType.Date]: 'tokenDate',
  // @ts-expect-error upgrade typescript v5.1.6
  [_types.InternalSchemaType.Date]: 'tokenDate',
  [_types.InternalSchemaType.Nested]: 'tokenNested'
};
const ResultToken = ({
  fieldType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: fieldTypeToTokenMap[fieldType]
  });
};
exports.ResultToken = ResultToken;