"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _result_actions = require("./result_actions");
var _result_header_item = require("./result_header_item");
require("./result_header.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultHeader = ({
  showScore,
  resultMeta,
  isMetaEngine,
  actions,
  documentLink,
  resultPosition,
  showClick
}) => {
  return /*#__PURE__*/_react.default.createElement("header", {
    className: "appSearchResultHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    responsive: false,
    wrap: true
  }, typeof resultPosition !== 'undefined' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.result.resultPositionLabel",
    defaultMessage: "#{resultPosition}",
    values: {
      resultPosition
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_result_header_item.ResultHeaderItem, {
    href: documentLink,
    "data-test-subj": "ResultId",
    field: "ID",
    value: resultMeta.id,
    type: "id"
  })), showClick && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_header_item.ResultHeaderItem, {
    "data-test-subj": "ResultClicks",
    field: "clicks",
    value: resultMeta.clicks,
    type: "clicks"
  })), showScore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_header_item.ResultHeaderItem, {
    "data-test-subj": "ResultScore",
    field: "Score",
    value: resultMeta.score,
    type: "score"
  })), isMetaEngine && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_header_item.ResultHeaderItem, {
    "data-test-subj": "ResultEngine",
    field: "Engine",
    value: resultMeta.engine,
    type: "string"
  })), actions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_actions.ResultActions, {
    actions: actions
  }))));
};
exports.ResultHeader = ResultHeader;