"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WeightSlider = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _relevance_tuning_logic = require("../../relevance_tuning_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WeightSlider = ({
  name,
  field
}) => {
  const {
    updateFieldWeight
  } = (0, _kea.useActions)(_relevance_tuning_logic.RelevanceTuningLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.manageFields.weight.label', {
      defaultMessage: 'Weight'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    min: 0,
    max: 10,
    step: 0.1,
    value: field.weight,
    onChange: e => updateFieldWeight(name, parseFloat(e.target.value)),
    showInput: true,
    compressed: true,
    fullWidth: true
  }));
};
exports.WeightSlider = WeightSlider;