"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionalBoostForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _constants = require("../../constants");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const functionOptions = Object.values(_types.FunctionalBoostFunction).map(boostFunction => ({
  value: boostFunction,
  text: _constants.FUNCTIONAL_BOOST_FUNCTION_DISPLAY_MAP[boostFunction]
}));
const operationOptions = Object.values(_types.BoostOperation).map(boostOperation => ({
  value: boostOperation,
  text: _constants.BOOST_OPERATION_DISPLAY_MAP[boostOperation]
}));
const FunctionalBoostForm = ({
  boost,
  index,
  name
}) => {
  const {
    updateBoostSelectOption
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.funtional.functionDropDownLabel', {
      defaultMessage: 'Function'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: `function-${_types.BoostType.Functional}${index}`,
    options: functionOptions,
    value: boost.function,
    onChange: e => updateBoostSelectOption(name, index, 'function', e.target.value),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.funtional.operationDropDownLabel', {
      defaultMessage: 'Operation'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: `operation-${_types.BoostType.Functional}${index}`,
    options: operationOptions,
    value: boost.operation,
    onChange: e => updateBoostSelectOption(name, index, 'operation', e.target.value),
    fullWidth: true
  })));
};
exports.FunctionalBoostForm = FunctionalBoostForm;