"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INPUT_ROW_PLACEHOLDER = exports.INPUT_ROW_CONTAINER_ARIA_LABEL = exports.DELETE_ROW_VALUE_BUTTON_LABEL = exports.ADD_VALUE_BUTTON_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_VALUE_BUTTON_LABEL = exports.ADD_VALUE_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.multiInputRows.addValueButtonLabel', {
  defaultMessage: 'Add value'
});
const DELETE_ROW_VALUE_BUTTON_LABEL = index => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.multiInputRows.removeRowValueButtonLabel', {
  defaultMessage: 'Remove value, row {index}',
  values: {
    index
  }
});
exports.DELETE_ROW_VALUE_BUTTON_LABEL = DELETE_ROW_VALUE_BUTTON_LABEL;
const INPUT_ROW_PLACEHOLDER = exports.INPUT_ROW_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.multiInputRows.inputRowPlaceholder', {
  defaultMessage: 'Enter a value'
});
const INPUT_ROW_CONTAINER_ARIA_LABEL = exports.INPUT_ROW_CONTAINER_ARIA_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.multiInputRows.inputRowContainerAriaLabel', {
  defaultMessage: 'Multiple input rows'
});