"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertLogRetentionFromServerToClient = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertLogRetentionFromServerToClient = logRetention => ({
  [_types.LogRetentionOptions.Analytics]: convertLogRetentionSettingsFromServerToClient(logRetention[_types.LogRetentionOptions.Analytics]),
  [_types.LogRetentionOptions.API]: convertLogRetentionSettingsFromServerToClient(logRetention[_types.LogRetentionOptions.API]),
  [_types.LogRetentionOptions.Audit]: convertLogRetentionSettingsFromServerToClient(logRetention[_types.LogRetentionOptions.Audit]),
  [_types.LogRetentionOptions.Crawler]: convertLogRetentionSettingsFromServerToClient(logRetention[_types.LogRetentionOptions.Crawler])
});
exports.convertLogRetentionFromServerToClient = convertLogRetentionFromServerToClient;
const convertLogRetentionSettingsFromServerToClient = ({
  disabled_at: disabledAt,
  enabled,
  retention_policy: retentionPolicy
}) => ({
  disabledAt,
  enabled,
  retentionPolicy: retentionPolicy === null ? null : convertLogRetentionPolicyFromServerToClient(retentionPolicy)
});
const convertLogRetentionPolicyFromServerToClient = ({
  min_age_days: minAgeDays,
  is_default: isDefault
}) => ({
  isDefault,
  minAgeDays
});