"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderLogRetentionDate = exports.NoLogging = exports.DefaultPolicy = exports.CustomPolicy = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderLogRetentionDate = dateString => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
  value: new Date(dateString),
  month: "long",
  day: "numeric",
  year: "numeric"
});
exports.renderLogRetentionDate = renderLogRetentionDate;
const CAPITALIZATION_MAP = {
  [_types.LogRetentionOptions.Analytics]: {
    capitalized: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.analytics.title.capitalized', {
      defaultMessage: 'Analytics'
    }),
    lowercase: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.analytics.title.lowercase', {
      defaultMessage: 'analytics'
    })
  },
  [_types.LogRetentionOptions.API]: {
    capitalized: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.api.title.capitalized', {
      defaultMessage: 'API'
    }),
    lowercase: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.api.title.lowercase', {
      defaultMessage: 'API'
    })
  },
  [_types.LogRetentionOptions.Audit]: {
    capitalized: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.audit.title.capitalized', {
      defaultMessage: 'Audit'
    }),
    lowercase: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.audit.title.lowercase', {
      defaultMessage: 'audit'
    })
  },
  [_types.LogRetentionOptions.Crawler]: {
    capitalized: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.crawler.title.capitalized', {
      defaultMessage: 'Web crawler'
    }),
    lowercase: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.type.crawler.title.lowercase', {
      defaultMessage: 'web crawler'
    })
  }
};
const NoLogging = ({
  type,
  disabledAt
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.logRetention.noLogging",
    defaultMessage: "{logsType} logging has been disabled for all engines.",
    values: {
      logsType: CAPITALIZATION_MAP[type].capitalized
    }
  }), ' ', disabledAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.logRetention.noLogging.collected",
    defaultMessage: "The last date {logsType} logs were collected was {disabledAtDate}.",
    values: {
      logsType: CAPITALIZATION_MAP[type].lowercase,
      disabledAtDate: renderLogRetentionDate(disabledAt)
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.logRetention.noLogging.notCollected",
    defaultMessage: "There are no {logsType} logs collected.",
    values: {
      logsType: CAPITALIZATION_MAP[type].lowercase
    }
  }));
};
exports.NoLogging = NoLogging;
const CustomPolicy = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.logRetention.customPolicy",
  defaultMessage: "You have a custom {logsType} log retention policy.",
  values: {
    logsType: CAPITALIZATION_MAP[type].lowercase
  }
});
exports.CustomPolicy = CustomPolicy;
const DefaultPolicy = ({
  type,
  minAgeDays
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.logRetention.defaultPolicy",
  defaultMessage: "Your {logsType} logs are being stored for at least {minAgeDays, plural, one {# day} other {# days}}.",
  values: {
    logsType: CAPITALIZATION_MAP[type].lowercase,
    minAgeDays
  }
});
exports.DefaultPolicy = DefaultPolicy;