"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRetentionCallout = exports.AUDIT_LOGS_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("..");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _app_logic = require("../../../app_logic");
var _routes = require("../../../routes");
var _analytics = require("../../analytics");
var _api_logs = require("../../api_logs");
var _crawler = require("../../crawler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUDIT_LOGS_TITLE = exports.AUDIT_LOGS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.audit.title', {
  defaultMessage: 'Audit'
});
const TITLE_MAP = {
  [_.LogRetentionOptions.Analytics]: _analytics.ANALYTICS_TITLE,
  [_.LogRetentionOptions.API]: _api_logs.API_LOGS_TITLE,
  [_.LogRetentionOptions.Audit]: AUDIT_LOGS_TITLE,
  [_.LogRetentionOptions.Crawler]: _crawler.CRAWLER_TITLE
};
const LogRetentionCallout = ({
  type
}) => {
  const {
    fetchLogRetention
  } = (0, _kea.useActions)(_.LogRetentionLogic);
  const {
    logRetention
  } = (0, _kea.useValues)(_.LogRetentionLogic);
  const {
    myRole: {
      canManageLogSettings
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const hasLogRetention = logRetention !== null;
  (0, _react.useEffect)(() => {
    if (!hasLogRetention && canManageLogSettings) fetchLogRetention();
  }, []);
  const logRetentionSettings = logRetention === null || logRetention === void 0 ? void 0 : logRetention[type];
  const title = TITLE_MAP[type];
  const hasLogRetentionDisabled = hasLogRetention && !(logRetentionSettings !== null && logRetentionSettings !== void 0 && logRetentionSettings.enabled);
  return hasLogRetentionDisabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "primary",
    title: logRetentionSettings !== null && logRetentionSettings !== void 0 && logRetentionSettings.disabledAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.appSearch.logRetention.callout.disabledSinceTitle",
      defaultMessage: "{logsTitle} have been disabled since {disabledDate}.",
      values: {
        logsTitle: title,
        disabledDate: (0, _.renderLogRetentionDate)(logRetentionSettings.disabledAt)
      }
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.callout.disabledTitle', {
      defaultMessage: '{logsTitle} have been disabled.',
      values: {
        logsTitle: title
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.logRetention.callout.description.manageSettingsDetail",
    defaultMessage: "To manage analytics & logging, {visitSettingsLink}.",
    values: {
      visitSettingsLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: _routes.SETTINGS_PATH
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.logRetention.callout.description.manageSettingsLinkText', {
        defaultMessage: 'visit your settings'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null;
};
exports.LogRetentionCallout = LogRetentionCallout;