"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineOverviewMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _suggested_curations_callout = require("./components/suggested_curations_callout");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineOverviewMetrics = () => {
  const {
    loadOverviewMetrics
  } = (0, _kea.useActions)(_.EngineOverviewLogic);
  const {
    dataLoading
  } = (0, _kea.useValues)(_.EngineOverviewLogic);
  (0, _react.useEffect)(() => {
    loadOverviewMetrics();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)(),
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.overview.heading', {
        defaultMessage: 'Engine overview'
      })
    },
    isLoading: dataLoading,
    "data-test-subj": "EngineOverview"
  }, /*#__PURE__*/_react.default.createElement(_suggested_curations_callout.SuggestedCurationsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_components.TotalStats, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_components.TotalCharts, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_components.RecentApiLogs, null));
};
exports.EngineOverviewMetrics = EngineOverviewMetrics;