"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ = require("..");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _analytics = require("../../analytics");
var _constants = require("../../analytics/constants");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TotalCharts = () => {
  const {
    startDate,
    queriesPerDay,
    operationsPerDay
  } = (0, _kea.useValues)(_.EngineOverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    "data-test-subj": "TotalQueriesChart",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.TOTAL_QUERIES),
    subtitle: _constants2.LAST_7_DAYS,
    action: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      iconType: "eye",
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_PATH),
      size: "s"
    }, _constants2.VIEW_ANALYTICS),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_analytics.AnalyticsChart, {
    lines: [{
      id: _constants.TOTAL_QUERIES,
      data: (0, _analytics.convertToChartData)({
        startDate,
        data: queriesPerDay
      })
    }],
    height: 240
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    "data-test-subj": "TotalApiOperationsChart",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.TOTAL_API_OPERATIONS),
    subtitle: _constants2.LAST_7_DAYS,
    action: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      iconType: "eye",
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_API_LOGS_PATH),
      size: "s"
    }, _constants2.VIEW_API_LOGS),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_analytics.AnalyticsChart, {
    lines: [{
      id: _constants.TOTAL_API_OPERATIONS,
      data: (0, _analytics.convertToChartData)({
        startDate,
        data: operationsPerDay
      })
    }],
    height: 240
  }))));
};
exports.TotalCharts = TotalCharts;