"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineCreation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _constants = require("../../../shared/constants");
var _query_params = require("../../../shared/query_params");
var _engines = require("../engines");
var _layout = require("../layout");
var _configure_app_search_engine = require("./configure_app_search_engine");
var _configure_elasticsearch_engine = require("./configure_elasticsearch_engine");
var _constants2 = require("./constants");
var _engine_creation_logic = require("./engine_creation_logic");
var _review_elasticsearch_engine = require("./review_elasticsearch_engine");
var _select_engine_type = require("./select_engine_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineCreation = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    method,
    ...params
  } = (0, _query_params.parseQueryParams)(search);
  const {
    engineType,
    currentEngineCreationStep
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    setIngestionMethod,
    initializeWithESIndex
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  (0, _react.useEffect)(() => {
    if (typeof method === 'string') {
      setIngestionMethod(method);
    }
    const esIndexParam = params[_constants.ESINDEX_QUERY_PARAMETER];
    if (typeof esIndexParam === 'string') {
      initializeWithESIndex(esIndexParam);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_engines.ENGINES_TITLE, _constants2.ENGINE_CREATION_TITLE],
    pageHeader: {
      pageTitle: _constants2.ENGINE_CREATION_TITLE
    },
    "data-test-subj": "EngineCreation"
  }, currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.SelectStep && /*#__PURE__*/_react.default.createElement(_select_engine_type.SelectEngineType, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ConfigureStep && engineType === 'appSearch' && /*#__PURE__*/_react.default.createElement(_configure_app_search_engine.ConfigureAppSearchEngine, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ConfigureStep && engineType === 'elasticsearch' && /*#__PURE__*/_react.default.createElement(_configure_elasticsearch_engine.ConfigureElasticsearchEngine, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ReviewStep && /*#__PURE__*/_react.default.createElement(_review_elasticsearch_engine.ReviewElasticsearchEngine, null));
};
exports.EngineCreation = EngineCreation;