"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEngineNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _layout = require("../../../shared/layout");
var _app_logic = require("../../app_logic");
var _routes = require("../../routes");
var _analytics = require("../analytics");
var _api_logs = require("../api_logs");
var _crawler = require("../crawler");
var _curations = require("../curations");
var _documents = require("../documents");
var _engine_overview = require("../engine_overview");
var _engines = require("../engines");
var _relevance_tuning = require("../relevance_tuning");
var _result_settings = require("../result_settings");
var _schema = require("../schema");
var _search_ui = require("../search_ui");
var _synonyms = require("../synonyms");
var _ = require(".");
require("./engine_nav.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEngineNav = () => {
  const isEngineRoute = !!(0, _reactRouterDom.useRouteMatch)(_routes.ENGINE_PATH);
  const {
    myRole: {
      canViewEngineAnalytics,
      canViewEngineDocuments,
      canViewEngineSchema,
      canViewEngineCrawler,
      canViewMetaEngineSourceEngines,
      canManageEngineSynonyms,
      canManageEngineCurations,
      canManageEngineRelevanceTuning,
      canManageEngineResultSettings,
      canManageEngineSearchUi,
      canViewEngineApiLogs
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    engineName,
    dataLoading,
    isSampleEngine,
    isMetaEngine,
    isElasticsearchEngine,
    hasSchemaErrors,
    hasSchemaConflicts,
    hasUnconfirmedSchemaFields,
    engine,
    hasIncompleteFields
  } = (0, _kea.useValues)(_.EngineLogic);
  if (!isEngineRoute) return undefined;
  if (dataLoading) return undefined;
  if (!engineName) return undefined;
  const navItems = [{
    id: 'engineName',
    name: engineName,
    renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      className: "appSearchNavEngineLabel"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textTruncate"
    }, engineName.toUpperCase()), isSampleEngine && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.sampleEngineBadge', {
      defaultMessage: 'SAMPLE ENGINE'
    })), isMetaEngine && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.metaEngineBadge', {
      defaultMessage: 'META ENGINE'
    })), isElasticsearchEngine && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.elasticsearchEngineBadge', {
      defaultMessage: 'ELASTICSEARCH INDEX'
    }))),
    'data-test-subj': 'EngineLabel'
  }, {
    id: 'overview',
    name: _engine_overview.OVERVIEW_TITLE,
    ...(0, _layout.generateNavLink)({
      to: (0, _.generateEnginePath)(_routes.ENGINE_PATH)
    }),
    'data-test-subj': 'EngineOverviewLink'
  }];
  if (canViewEngineAnalytics) {
    navItems.push({
      id: 'analytics',
      name: _analytics.ANALYTICS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_ANALYTICS_PATH),
        shouldShowActiveForSubroutes: true
      }),
      'data-test-subj': 'EngineAnalyticsLink'
    });
  }
  if (canViewEngineDocuments) {
    navItems.push({
      id: 'documents',
      name: _documents.DOCUMENTS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_DOCUMENTS_PATH),
        shouldShowActiveForSubroutes: true
      }),
      'data-test-subj': 'EngineDocumentsLink'
    });
  }
  if (canViewEngineSchema) {
    navItems.push({
      id: 'schema',
      name: _schema.SCHEMA_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_SCHEMA_PATH),
        shouldShowActiveForSubroutes: true
      }),
      'data-test-subj': 'EngineSchemaLink',
      icon: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasSchemaErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.errors', {
          defaultMessage: 'Schema change errors'
        }),
        "data-test-subj": "EngineNavSchemaErrors"
      }), hasUnconfirmedSchemaFields && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "iInCircle",
        color: "primary",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.unconfirmedFields', {
          defaultMessage: 'New unconfirmed fields'
        }),
        "data-test-subj": "EngineNavSchemaUnconfirmedFields"
      }), hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.conflicts', {
          defaultMessage: 'Schema conflicts'
        }),
        "data-test-subj": "EngineNavSchemaConflicts"
      }), hasIncompleteFields && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.hasIncompleteFields', {
          defaultMessage: 'Precision tuning is not enabled on all fields'
        }),
        "data-test-subj": "EngineNavPrecisionTuningWarning"
      }))
    });
  }
  const showCrawlerNavItem = canViewEngineCrawler && !isMetaEngine && !isElasticsearchEngine;
  if (showCrawlerNavItem) {
    navItems.push({
      id: 'crawler',
      name: _crawler.CRAWLER_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_CRAWLER_PATH),
        shouldShowActiveForSubroutes: true
      }),
      'data-test-subj': 'EngineCrawlerLink'
    });
  }
  if (canViewMetaEngineSourceEngines && isMetaEngine) {
    navItems.push({
      id: 'sourceEngines',
      name: _engines.ENGINES_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.META_ENGINE_SOURCE_ENGINES_PATH)
      }),
      'data-test-subj': 'MetaEngineEnginesLink'
    });
  }
  if (canManageEngineRelevanceTuning) {
    const {
      invalidBoosts,
      unsearchedUnconfirmedFields
    } = engine;
    navItems.push({
      id: 'relevanceTuning',
      name: _relevance_tuning.RELEVANCE_TUNING_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_RELEVANCE_TUNING_PATH)
      }),
      'data-test-subj': 'EngineRelevanceTuningLink',
      icon: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, invalidBoosts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.invalidBoosts', {
          defaultMessage: 'Invalid boosts'
        }),
        "data-test-subj": "EngineNavRelevanceTuningInvalidBoosts"
      }), unsearchedUnconfirmedFields && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        className: "appSearchNavIcon",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.unsearchedFields', {
          defaultMessage: 'Unsearched fields'
        }),
        "data-test-subj": "EngineNavRelevanceTuningUnsearchedFields"
      }))
    });
  }
  if (canManageEngineSynonyms) {
    navItems.push({
      id: 'synonyms',
      name: _synonyms.SYNONYMS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_SYNONYMS_PATH)
      }),
      'data-test-subj': 'EngineSynonymsLink'
    });
  }
  if (canManageEngineCurations) {
    navItems.push({
      id: 'curations',
      name: _curations.CURATIONS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_CURATIONS_PATH),
        shouldShowActiveForSubroutes: true
      }),
      'data-test-subj': 'EngineCurationsLink'
    });
  }
  if (canManageEngineResultSettings) {
    navItems.push({
      id: 'resultSettings',
      name: _result_settings.RESULT_SETTINGS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_RESULT_SETTINGS_PATH)
      }),
      'data-test-subj': 'EngineResultSettingsLink'
    });
  }
  if (canManageEngineSearchUi) {
    navItems.push({
      id: 'searchUI',
      name: _search_ui.SEARCH_UI_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_SEARCH_UI_PATH)
      }),
      'data-test-subj': 'EngineSearchUILink'
    });
  }
  if (canViewEngineApiLogs) {
    navItems.push({
      id: 'apiLogs',
      name: _api_logs.API_LOGS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: (0, _.generateEnginePath)(_routes.ENGINE_API_LOGS_PATH)
      }),
      'data-test-subj': 'EngineAPILogsLink'
    });
  }
  return navItems;
};
exports.useEngineNav = useEngineNav;