"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchContextState = exports.useSearchContextActions = void 0;
var _react = require("react");
var _reactSearchUi = require("@elastic/react-search-ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchContextState = () => {
  const {
    driver
  } = (0, _react.useContext)(_reactSearchUi.SearchContext);
  const [state, setState] = (0, _react.useState)(driver.state);
  (0, _react.useEffect)(() => {
    const subscription = newState => {
      setState(newState);
    };
    driver.subscribeToStateChanges(subscription);
    return () => {
      driver.unsubscribeToStateChanges(subscription);
    };
  }, [state]);
  return state;
};
exports.useSearchContextState = useSearchContextState;
const useSearchContextActions = () => {
  const {
    driver
  } = (0, _react.useContext)(_reactSearchUi.SearchContext);
  return driver.actions;
};
exports.useSearchContextActions = useSearchContextActions;